/*
  A simple class for storing some basic information about tokens.

  Inspired by Yytoken from the simple-maven example of JFlex.
 */
class ArithToken {
    /*
      A list of allowed types of tokens in our language.
    */
    enum Type {
	STRING_TYPE (5),   // The type "String" in the declaration of variables.
	INT_TYPE    (2),   // The type "int" in the declaration of variables.
	IDENTIFIER  (1),   // An identifier.
	NUMBER      (3),   // An integer number.
	STRING      (4),   // A string literal.
	EQUALS      (61),  // The = sign.
	PLUS        (43),
	MINUS       (45),
	LPAREN      (40),  // The opening (left) parenthesis sign: ( .
	RPAREN      (41),  // The closing (right) parenthesis sign: ) .
	SCOLON      (59);  // The semicolon sign: ; .

	public int intVal;
	Type(int v) { intVal = v; };
    }


    // The type of the token.
    public Type type;

    // The string content of the token.
    public String text;

    // The position of the token in the parsed string.
    public int line;
    public int start;
    public int end;

    public ArithToken (Type tp, String tx, int l, int s, int e) {
	type = tp;
	text = tx;
	line = l;
	start = s;
	end = e;
    }

    public String toString() {
	return "\n==>Token '" + text + "' in line " + line + ", characters " + start + "-" + end + "\n\n";
    }
}
